# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.widgets.list_vertical import ListVertical

from elisa.plugins.poblesec.widgets.sliced_image import SlicedImageHorizontal

from pgm.timing import implicit

import gobject


class ActionSelector(Widget):

    def __init__(self):
        super(ActionSelector, self).__init__()
        self._cursors = {}
        self._update_style_properties(self._style.get_items())

    def create_cursor(self, name):
        cursor = SlicedImageHorizontal()
        self.add(cursor)
        cursor.opacity = 0
        cursor.visible = True

        animated_cursor = implicit.AnimatedObject(cursor)
        settings = {'duration': 200,
                    'transformation': implicit.DECELERATE}
        animated_cursor.setup_next_animations(**settings)
        animated_cursor.mode = implicit.REPLACE

        # store the cursor
        self._cursors[name] = animated_cursor

        # if it's the only cursor show it
        if len(self._cursors) == 1:
            cursor.opacity = 255

        self._update_cursor_style(name)

    def set_left_cap(self, image_path):
        for name, animated_cursor in self._cursors.iteritems():
            animated_cursor.static_object.left_cap.set_from_file(image_path)

    def set_right_cap(self, image_path):
        for name, animated_cursor in self._cursors.iteritems():
            animated_cursor.static_object.right_cap.set_from_file(image_path)

    def set_body(self, image_path):
        for name, animated_cursor in self._cursors.iteritems():
            animated_cursor.static_object.body.set_from_file(image_path)

    def select_cursor(self, name):
        for local_name, animated_cursor in self._cursors.iteritems():
            if local_name != name:
                animated_cursor.opacity = 0

        self._cursors[name].opacity = 255

    def _update_style_properties(self, props=None):
        super(ActionSelector, self)._update_style_properties(props)

        if props is None:
            return

        for key, value in props.iteritems():
            # separate the first fragment from the rest of the key
            # it is considered as being the name of the cursor
            # what's left is considered as being the cursor's attribute
            cursor_name, attribute = key.split('-', 1)
            if self._cursors.has_key(cursor_name):
                cursor = self._cursors[cursor_name].static_object
                setattr(cursor, attribute, value)

    def _update_cursor_style(self, name):
        cursor = self._cursors[name].static_object

        for key, value in self._style.get_items().iteritems():
            # separate the first fragment from the rest of the key
            # it is considered as being the name of the cursor
            # what's left is considered as being the cursor's attribute
            cursor_name, attribute = key.split('-', 1)
            if cursor_name == name:
                setattr(cursor, attribute, value)


class ActionListSelector(ListVertical):

    action_selected = False
    widget_signals = {'clicked' : 'item-clicked', 'action': 'action-clicked'}


    __gsignals__ = {
        'action-clicked': (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,)),
        }

    def select_list_item(self):
        if self._selector is None:
            return
        self.action_selected = False
        self._selector.select_cursor("item")

    def select_action_item(self):
        if self._selector is None:
            return
        self.action_selected = True
        self._selector.select_cursor("action")
