# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from twisted.internet import defer
from elisa.plugins.poblesec.link import Link
from elisa.core.utils.i18n import install_translation

_ = install_translation('poblesec')

def settings_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/settings_menu"
    link.label = _("Settings")
    link.icon = "elisa.plugins.poblesec.settings_section"
    controller.model.append(link)

    return defer.succeed(None)

def directory_settings_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/settings/directory_settings"
    link.label = _("Add folders")
    link.icon = "elisa.plugins.poblesec.directory_settings_add_folder"

    return defer.succeed(None)

def login_settings_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/settings/login"
    link.label = _("User Accounts")
    link.icon = "elisa.plugins.poblesec.key_icon"
    controller.model.append(link)

    return defer.succeed(None)

