import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

setup(name='elisa-plugin-theme-hp',
    version='1.0.0',
    description='HP theme',
    license='GPL3', 
    author='HP',
    author_email='hp@hp.com',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.conf', 'harbour/*.png'],
                 },
    controller_mappings=[('/poblesec/about',
                          'elisa.plugins.hp.about:AboutController'),],
    decorator_mappings=[('/poblesec/settings_menu',
                         'elisa.plugins.hp.about:about_main_menu_decorator'),],
    cmdclass=cmdclass)
