/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.nl;

import java.io.File;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.nl.DutchStemFilter;
import org.apache.lucene.analysis.nl.WordlistLoader;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class DutchAnalyzer
extends Analyzer {
    public static final String[] DUTCH_STOP_WORDS = new String[]{"de", "en", "van", "ik", "te", "dat", "die", "in", "een", "hij", "het", "niet", "zijn", "is", "was", "op", "aan", "met", "als", "voor", "had", "er", "maar", "om", "hem", "dan", "zou", "of", "wat", "mijn", "men", "dit", "zo", "door", "over", "ze", "zich", "bij", "ook", "tot", "je", "mij", "uit", "der", "daar", "haar", "naar", "heb", "hoe", "heeft", "hebben", "deze", "u", "want", "nog", "zal", "me", "zij", "nu", "ge", "geen", "omdat", "iets", "worden", "toch", "al", "waren", "veel", "meer", "doen", "toen", "moet", "ben", "zonder", "kan", "hun", "dus", "alles", "onder", "ja", "eens", "hier", "wie", "werd", "altijd", "doch", "wordt", "wezen", "kunnen", "ons", "zelf", "tegen", "na", "reeds", "wil", "kon", "niets", "uw", "iemand", "geweest", "andere"};
    private Set stoptable = new HashSet();
    private Set excltable = new HashSet();
    private Map _stemdict = new HashMap();

    public DutchAnalyzer() {
        this.stoptable = StopFilter.makeStopSet((String[])DUTCH_STOP_WORDS);
        this._stemdict.put("fiets", "fiets");
        this._stemdict.put("bromfiets", "bromfiets");
        this._stemdict.put("ei", "eier");
        this._stemdict.put("kind", "kinder");
    }

    public DutchAnalyzer(String[] stopwords) {
        this.stoptable = StopFilter.makeStopSet((String[])stopwords);
    }

    public DutchAnalyzer(HashSet stopwords) {
        this.stoptable = stopwords;
    }

    public DutchAnalyzer(File stopwords) {
        this.stoptable = new HashSet(WordlistLoader.getWordtable(stopwords).keySet());
    }

    public void setStemExclusionTable(String[] exclusionlist) {
        this.excltable = StopFilter.makeStopSet((String[])exclusionlist);
    }

    public void setStemExclusionTable(HashSet exclusionlist) {
        this.excltable = exclusionlist;
    }

    public void setStemExclusionTable(File exclusionlist) {
        this.excltable = new HashSet(WordlistLoader.getWordtable(exclusionlist).keySet());
    }

    public void setStemDictionary(File stemdict) {
        this._stemdict = WordlistLoader.getStemDict(stemdict);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new StandardTokenizer(reader);
        result = new StandardFilter((TokenStream)result);
        result = new StopFilter((TokenStream)result, this.stoptable);
        result = new DutchStemFilter((TokenStream)result, this.excltable, this._stemdict);
        return result;
    }
}

