/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "SsidInputDialog.h"

#include <wx/intl.h>
#include <wx/string.h>
#include <wx/msgdlg.h>
#include "ENMUtil.h"

const long SsidInputDialog::ID_STX_SSID = wxNewId();
const long SsidInputDialog::ID_STATICTEXT1 = wxNewId();
const long SsidInputDialog::ID_TXT_SSID = wxNewId();
const int SsidInputDialog::ID_BTN_OK = ::wxNewId();
const int SsidInputDialog::ID_BTN_CANCEL = ::wxNewId();
BEGIN_EVENT_TABLE(SsidInputDialog, wxDialog)
    EVT_BUTTON(ID_BTN_OK, SsidInputDialog::OnButtonClick)
    EVT_BUTTON(ID_BTN_CANCEL, SsidInputDialog::OnButtonClick)
END_EVENT_TABLE()

SsidInputDialog::SsidInputDialog(wxWindow* parent)
{
	Create(parent, wxID_ANY, _("Connect to Wireless Network"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxSize(400,114));
	Move(wxDefaultPosition);
	m_stxLabel = new wxStaticText(this, ID_STX_SSID, _("Please input network name (SSID)."), wxPoint(16,10), wxSize(336,14), 0, _T("ID_STX_SSID"));
	m_stxSsid = new wxStaticText(this, ID_STATICTEXT1, _("SSID:"), wxPoint(16,40), wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	m_txtSsid = new wxTextCtrl(this, ID_TXT_SSID, wxEmptyString, wxPoint(80,36), wxSize(304,22), 0, wxDefaultValidator, _T("ID_TXT_SSID"));
	m_txtSsid->SetMaxLength(32);
#if defined(__WXMSW__)
	m_btnOK = new wxButton(this, ID_BTN_OK, _("OK"), wxPoint(208,74), wxSize(80,24), 0, wxDefaultValidator, _T("ID_BTN_OK"));
	m_btnCancel = new wxButton(this, ID_BTN_CANCEL, _("Cancel"), wxPoint(304,74), wxSize(80,24), 0, wxDefaultValidator, _T("ID_BTN_CANCEL"));
#else
	m_btnOK = new wxButton(this, ID_BTN_OK, _("OK"), wxPoint(304,80), wxSize(80,32), 0, wxDefaultValidator, _T("ID_BTN_OK"));
	m_btnCancel = new wxButton(this, ID_BTN_CANCEL, _("Cancel"), wxPoint(208,80), wxSize(80,32), 0, wxDefaultValidator, _T("ID_BTN_CANCEL"));
#endif
	m_btnOK->SetDefault();
	Center();
}

SsidInputDialog::~SsidInputDialog()
{
}

void SsidInputDialog::OnButtonClick(wxCommandEvent& event)
{
    int buttonId = event.GetId();
    if ( buttonId == ID_BTN_OK )
    {
        m_strSsid = m_txtSsid->GetValue();
        if ( m_strSsid.IsEmpty() )
        {
            wxMessageDialog msg(this, _("SSID cannot be empty!"), wxEmptyString, wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            m_txtSsid->SetFocus();
            return;
        }
        if ( ENMUtil::CheckValide(m_strSsid) == ENMUtil::CHECK_ILLEGAL )
        {
            wxMessageDialog msg(this, _("SSID cannot contain any of the following characters\n \\ / : * ? \" < > |"), wxEmptyString, wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            m_txtSsid->SetFocus();
            return;
        }
    }
    else
    {
        m_strSsid.Clear();
    }
    if ( buttonId == ID_BTN_OK )
    {
        EndModal(wxID_OK);
    }
    else
    {
        EndModal(wxID_CANCEL);
    }
}

wxString SsidInputDialog::GetSsid() const
{
    return m_strSsid;
}
