/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifdef WX_PRECOMP
#include "wx_pch.h"
#endif

#ifdef __BORLANDC__
#pragma hdrstop
#endif //__BORLANDC__

#include "ENMApp.h"
#include "ENMTaskTray.h"
#include "wx/image.h"

#if defined(__WXMSW__)
#include "Windows.h"
#include <shlwapi.h>
#endif
#include "ENMUtil.h"
#if defined(__WXMSW__)
#include <wx/stdpaths.h>
#include <DCS/DCSApi.h>
#endif
#if defined(__UNIX__)
#include <sdk/DCSApi.h>
#include <X11/Xatom.h>
#include <gdk/gdkx.h>
#endif

#if defined(__WXMSW__)
static const wxString logFile(_T("C:\\ENMApp.log"));
#else
static const wxString logFile(_T("/tmp/ENMApp.log"));
#endif

IMPLEMENT_APP(ENMApp)

const int ENMApp::ID_TIMER_INIT = ::wxNewId();
const int ENMApp::ID_TIMER_NOTIFY = ::wxNewId();

BEGIN_EVENT_TABLE(ENMApp, wxApp)
    EVT_TIMER(ID_TIMER_INIT, ENMApp::OnTimerInit)
    EVT_TIMER(ID_TIMER_NOTIFY, ENMApp::CloseNotification)
END_EVENT_TABLE()

ENMApp::ENMApp() : wxApp()
        , m_timerInit(this, ID_TIMER_INIT)
        , m_notificationtimer(this, ID_TIMER_NOTIFY)
{
    m_taskBarIcon = NULL;
}

bool ENMApp::OnInit()
{
    wxInitAllImageHandlers();
    m_notificationDlg = NULL;
    m_ifExit = false;
    m_popBalloon = false;
    if ( ENMUtil::IsGuest() )
    {
        return false;
    }

    LoadResource();

    if ( !GetLock() )
    {
        if ( IsProtocolSupported() )
        {
            ShowMainFrame();
            PopupNotification();
            m_ifExit = true;
            return true;
        }
        else
        {
            system("/usr/share/EasyNetworkManager/restart.sh");
            return false;
        }
    }
    else
    {
        m_popBalloon = true;
    }

    m_timerInit.Start(20000, wxTIMER_ONE_SHOT);
    return true;
}

int ENMApp::OnExit()
{
    if ( m_taskBarIcon != NULL )
    {
        delete m_taskBarIcon;
        m_taskBarIcon = NULL;
    }
    return wxApp::OnExit();
}

bool ENMApp::SetImage(char* image)
{
    wxIcon icon(&image);
    return m_taskBarIcon->SetIcon(icon, _T("Easy Network"));
}

ENMTaskTray* ENMApp::GetENMTaskTray()
{
    return m_taskBarIcon;
}

bool ENMApp::GetLock()
{
#if defined(__UNIX__)
    struct flock fl;
    int fdlock = 0;

    fl.l_type = F_WRLCK;
    fl.l_whence = SEEK_SET;
    fl.l_start = 0;
    fl.l_len = 1;
    string file = ENMUtil::WxStringToString(::wxGetHomeDir()) + "/.enm_lock";
    if( (fdlock = open(file.c_str(), O_WRONLY|O_CREAT, 0666)) == -1 )
        return false;

    return fcntl(fdlock, F_SETLK, &fl) != -1;
#endif
#if defined(__WXMSW__)
    const wxString name = _T("ENMApp-%s") + wxGetUserId();
    m_checker = new wxSingleInstanceChecker(name);
    return !m_checker->IsAnotherRunning();
#endif
}

bool ENMApp::ShowMainFrame()
{
#if defined(__WXMSW__)
    HWND hWnd = FindWindow(NULL, _("Network Manager"));
    if ( hWnd == NULL )
        return false;
    PostMessage(hWnd, WM_ACTIVATE, WA_ACTIVE, 0);
#endif
    return true;
}

void ENMApp::OnTimerInit(wxTimerEvent& event)
{
    if ( !InitializeDCS() )
    {
        ::wxExit();
        return;
    }
#if defined(__WXMSW__)
    DCS_SetAbortHandler(DCSAbortHandler);
#endif
/*
    ENM_InitUserInfo userInfo;
    memcpy(userInfo.userPath.dcsString, ENMUtil::WxStringToString(ENMUtil::GetCurrentUserAppDataFolder()).c_str(), 256);
    DCS_InitUserInfo(userInfo);
*/
//    wxInitAllImageHandlers();
    m_taskBarIcon = ENMTaskTray::GetInstance();
    m_taskBarIcon->init(argc == 2);
}

bool ENMApp::InitializeDCS()
{
    return DCS_Initialize() == DCS_SUCCESS;
}

bool ENMApp::IsProtocolSupported()
{
#if defined(__UNIX__)
    Display *display = GDK_DISPLAY();
    Screen *screen = DefaultScreenOfDisplay(display);

    char name[32];
    g_snprintf(name, sizeof(name), "_NET_SYSTEM_TRAY_S%d", XScreenNumberOfScreen(screen));
    Atom atom = XInternAtom(display, name, False);
    Window manager = XGetSelectionOwner(display, atom);

    return manager != None;
#endif
#if defined(__WXMSW__)
    return true;
#endif
}

bool ENMApp::LoadResource()
{
#if defined(__WXMSW__)
#ifdef __WXDEBUG__
    TCHAR tszPath[MAX_PATH];
    GetModuleFileName(NULL,tszPath,MAX_PATH);
    PathRemoveFileSpec(tszPath);
    strAppPath = tszPath;
#else
    strAppPath = wxStandardPaths::Get().GetDataDir();
#endif
    strAppPath += _T("\\");
    strResourcePath = strAppPath + _T("resource");
    strImagePath = strAppPath + _T("pic\\");
    strManualPath = strAppPath;
    strManualFileName = strAppPath + _T("Intel_CMPC2.0_Easy_Network_User_Manual.pdf");
    m_locale.AddCatalogLookupPathPrefix(strResourcePath);
    return m_locale.AddCatalog(_T("resource"));
#endif // __WXMSW__
#if defined(__UNIX__)
    system("killall nm-applet");
    char appName[256] = { 0 };
    readlink("/proc/self/exe", appName, 256);
    strAppPath = wxString::FromUTF8(appName);
    strAppPath = strAppPath.SubString(0, strAppPath.Find('/', true));

    int langCode = wxLocale::GetSystemLanguage();
    wxString resource = ENMUtil::GetLocaleFileName(langCode);
    strResourcePath = strAppPath + _T("resource/");
    strImagePath = strAppPath + _T("pic/");
    strManualPath = _T("/usr/share/doc/easy-network/");
    strManualFileName = strManualPath + _T("Intel_CMPC2.0_Easy_Network_User_Manual_") + resource + _T(".pdf.gz");
    m_locale.AddCatalogLookupPathPrefix(strResourcePath);
    return m_locale.AddCatalog(_T("resource_") + resource);
#endif
}

void CALLBACK DCSAbortHandler()
{
#if defined(__WXMSW__)
    DCS_Return_Code ret = DCS_Initialize();
    while ( ret != DCS_SUCCESS )
    {
         wxSleep(30);
         ret = DCS_Initialize();
    }
    DCS_SetAbortHandler(DCSAbortHandler);
#endif
}

void ENMApp::PopupNotification()
{
    if (NULL == m_notificationDlg)
    {
        m_notificationDlg = new ENExistBalloon(NULL);
//        m_notificationDlg->PopupNotification();
        m_notificationDlg->Show(true);
    }

    m_notificationtimer.Start(3000, wxTIMER_ONE_SHOT);
}

void ENMApp::CloseNotificationHandler()
{
   if (NULL != m_notificationDlg)
    {
        m_notificationDlg->Show(false);
        delete m_notificationDlg;
        m_notificationDlg = NULL;
    }

    m_notificationtimer.Stop();
    if ( m_ifExit )
    {
        ::wxExit();
    }
}

void ENMApp::CloseNotification(wxTimerEvent & event)
{
    CloseNotificationHandler();
}

