/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * callbacks.c
 * Copyright (C) a 2009 <a@a>
 * 
 * callbacks.c is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * callbacks.c is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "callbacks.h"
#include "common.h"


void
destroy (GtkWidget *widget, gpointer data)
{
	g_print ("destroy()\n");
	gtk_main_quit ();
}

void
on_startup_show (GtkWidget *widget)
{
	g_print ("on_startup_show()\n");
	dt_start_display_timer ();
	dt_start_excution ();
}

gint
on_display_timeout_callback (gpointer data)
{
	g_print ("on_display_timeout_callback()\n");
	if (gdtag){
		gtk_timeout_remove (gdtag);
	}
	gtk_widget_hide (gdialog);
	/* return zero for timer stop */
	return 0;
}

gint
on_invalid_timeout_callback (gpointer data)
{
	g_print ("on_invalid_timeout_callback()\n");
	if (gktag){
		gtk_timeout_remove (gktag);
	}
	gtk_widget_destroy (gdialog);
	/* return zero for timer stop */
	return 0;
}

/* It is called when the data of a selection is needed. */
void
signal_selection_get (GtkWidget *widget, GtkSelectionData *data, guint info,
                      guint time, gpointer user_data)
{
	g_print ("signal_selection_get() start\n");
	g_print ("signal_selection_get() user_data[%s]\n", (const gchar*)user_data);

	if (strcmp((const gchar*)user_data, (const gchar*)DT_NAME_HOME) == 0){
		if (data->selection == gatom_home && info == TARGET_STRING)
		{
			g_print ("signal_selection_get() >> if() is TRUE\n");
			gtk_selection_data_set (data, GDK_SELECTION_TYPE_STRING,
									8 * sizeof (gchar), (guchar*)DT_NAME_HOME, 7);
		}
	}else if (strcmp((const gchar*)user_data, (const gchar*)DT_NAME_WEB) == 0){
		if (data->selection == gatom_web && info == TARGET_STRING)
		{
			g_print ("signal_selection_get() >> if() is TRUE\n");
			gtk_selection_data_set (data, GDK_SELECTION_TYPE_STRING,
									8 * sizeof (gchar), (guchar*)DT_NAME_WEB, 7);
		}
	}else if (strcmp((const gchar*)user_data, (const gchar*)DT_NAME_MAIL) == 0){
		if (data->selection == gatom_mail && info == TARGET_STRING)
		{
			g_print ("signal_selection_get() >> if() is TRUE\n");
			gtk_selection_data_set (data, GDK_SELECTION_TYPE_STRING,
									8 * sizeof (gchar), (guchar*)DT_NAME_MAIL, 7);
		}
	}else{
		if (data->selection == gatom_user && info == TARGET_STRING)
		{
			g_print ("signal_selection_get() >> if() is TRUE\n");
			gtk_selection_data_set (data, GDK_SELECTION_TYPE_STRING,
									8 * sizeof (gchar), (guchar*)DT_NAME_USER, 7);
		}
	}
}

/* It is called when the data of a selection is able to be acquired. */
void
signal_selection_received (GtkWidget *widget, GtkSelectionData *data,
                           guint time, gpointer user_data)
{
	g_print ("signal_selection_received() start\n");
	g_print ("signal_selection_received() user_data[%s]\n", (const gchar*)user_data);

	/* When data has been sent from other processes, length memba is zero or more. */
	if (strcmp((const gchar*)user_data, (const gchar*)DT_NAME_HOME) == 0){
		if (data->selection == gatom_home)
		{
			g_print ("signal_selection_received() >> if() is TRUE\n");
			ginst_home = MAX (data->length, 0);
		}
	}else if (strcmp((const gchar*)user_data, (const gchar*)DT_NAME_WEB) == 0){
		if (data->selection == gatom_web)
		{
			g_print ("signal_selection_received() >> if() is TRUE\n");
			ginst_web = MAX (data->length, 0);
		}
	}else if (strcmp((const gchar*)user_data, (const gchar*)DT_NAME_MAIL) == 0){
		if (data->selection == gatom_mail)
		{
			g_print ("signal_selection_received() >> if() is TRUE\n");
			ginst_mail = MAX (data->length, 0);
		}
	}else{
		if (data->selection == gatom_user)
		{
			g_print ("signal_selection_received() >> if() is TRUE\n");
			ginst_user = MAX (data->length, 0);
		}
	}
}

