/*
 * Copyright (C) 2008 Dell Inc.
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _HAVE_LAUNCHER_MENU_APPLICATION_H
#define _HAVE_LAUNCHER_MENU_APPLICATION_H

#include <glib.h>
#include <gtk/gtk.h>
#include <gmenu-tree.h>
#include <libwnck/window.h>
#include <clutter/clutter.h>

#include "launcher-menu-category.h"

typedef struct _LauncherMenuApplication LauncherMenuApplication;

struct _LauncherMenuApplication
{
  LauncherMenuCategory *category;
  
  GdkPixbuf *pixbuf;

  ClutterActor *texture;
  
  gchar *name;
  gchar *comment;
  gchar *icon;
  gchar *exec;
  gchar *path;

  WnckWindow *window;
  gint pid;

  gboolean isnew;
};


/* Application functions */
const gchar *
launcher_menu_application_get_name      (LauncherMenuApplication *application);

const gchar *
launcher_menu_application_get_comment   (LauncherMenuApplication *application);

GdkPixbuf*
launcher_menu_application_get_icon      (LauncherMenuApplication *application);

const gchar *
launcher_menu_application_get_icon_name (LauncherMenuApplication *application);

ClutterTexture *
launcher_menu_application_get_texture   (LauncherMenuApplication *application);

LauncherMenuCategory*
launcher_menu_application_get_category  (LauncherMenuApplication *application);

GdkPixbuf *
launcher_menu_application_get_pixbuf    (LauncherMenuApplication *application,
                                         guint size);
const gchar*
launcher_menu_application_get_exec      (LauncherMenuApplication *application);

const gchar *
launcher_menu_application_get_desktop_filename (LauncherMenuApplication *application);

gboolean
launcher_menu_application_is_new        (LauncherMenuApplication *application);

void
launcher_menu_application_set_new       (LauncherMenuApplication *application, 
                                         gboolean                 is_new);

gint
launcher_menu_application_get_pid       (LauncherMenuApplication *application);
void
launcher_menu_application_set_pid       (LauncherMenuApplication *application,  
                                         gint                     pid);

WnckWindow *
launcher_menu_application_get_window    (LauncherMenuApplication *applicaton);
void
launcher_menu_application_set_window    (LauncherMenuApplication *application,
                                         WnckWindow              *window);

G_END_DECLS

#endif /* _HAVE_LAUNCHER_MENU_APPLICATION_H */
