/*
 * Copyright (C) 2008 Dell Inc.
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_CATBAR_H_
#define _LAUNCHER_CATBAR_H_

#include <glib-object.h>
#include <clutter/clutter.h>

#include "launcher-menu.h"
#include "launcher-category.h"


#define LAUNCHER_TYPE_CATBAR (launcher_catbar_get_type ())

#define LAUNCHER_CATBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	LAUNCHER_TYPE_CATBAR, LauncherCatbar))

#define LAUNCHER_CATBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	LAUNCHER_TYPE_CATBAR, LauncherCatbarClass))

#define LAUNCHER_IS_CATBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	LAUNCHER_TYPE_CATBAR))

#define LAUNCHER_IS_CATBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	LAUNCHER_TYPE_CATBAR))

#define LAUNCHER_CATBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	LAUNCHER_TYPE_CATBAR, LauncherCatbarClass))

typedef struct _LauncherCatbar        LauncherCatbar;
typedef struct _LauncherCatbarClass   LauncherCatbarClass;
typedef struct _LauncherCatbarPrivate LauncherCatbarPrivate;
 
struct _LauncherCatbar
{
  ClutterGroup        parent;	

  LauncherCatbarPrivate *priv;
};

struct _LauncherCatbarClass
{
  ClutterGroupClass   parent_class;

  /*< signals />*/
  void (*category_selected) (LauncherCatbar       *catbar, 
                             LauncherMenuCategory *category);
};

GType launcher_catbar_get_type (void) G_GNUC_CONST;

ClutterActor * launcher_catbar_get_default (void);

void           launcher_catbar_set        (LauncherCatbar   *bar,
                                           LauncherCategory *cat);
void           launcher_catbar_unset      (LauncherCatbar   *bar);

#endif /* _LAUNCHER_CATBAR_H_ */

