/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by
 *              Neil Jagdish Patel <neil.patel@canonical.com>
 *              Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 * Compile with:
 *
 * valac --vapidir ../vapi --pkg glib-2.0 --pkg gtk+-2.0 --pkg dee master-model.vala -o master-model-vala -X -I../dee
 */

using GLib;
using Dee;

public class Master
{
  private Model model;

  public Master ()
  {
    this.model = new Model ("com.canonical.Dee.Model.Example",
                            2,
                            typeof (int),
                            typeof (string));
    this.model.row_added.connect (this.on_row_added);
    this.model.connect ();
  }

  private void on_row_added (ModelIter iter)
  {
    int    i;
    string s;

    this.model.get (iter, 0, out i, 1, out s, -1);
  
    i = this.model.get_int (iter, 0);
    var ss = this.model.get_string (iter, 1);

    print (@"Mastr: $i $ss\n");
  }
}

public static int main (string[] args)
{
  Gtk.init (ref args);

  Master master;
  
  master = new Master ();

  Gtk.main ();

  return 0;
}
