/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_IMAGE_H_
#define _CTK_IMAGE_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <ctk/ctk-actor.h>

G_BEGIN_DECLS

#define CTK_TYPE_IMAGE (ctk_image_get_type ())

#define CTK_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_IMAGE, CtkImage))

#define CTK_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_IMAGE, CtkImageClass))

#define CTK_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_IMAGE))

#define CTK_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_IMAGE))

#define CTK_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_IMAGE, CtkImageClass))

typedef struct _CtkImage        CtkImage;
typedef struct _CtkImageClass   CtkImageClass;
typedef struct _CtkImagePrivate CtkImagePrivate;
 
struct _CtkImage
{
  CtkActor parent;	

  CtkImagePrivate *priv;
};

struct _CtkImageClass
{
  /*< private >*/
  CtkActorClass  parent_class;

  /*< public >*/
  /* signals, not vfuncs */

  /* vtable */

  /*< private >*/
  /* padding */
  void (*_ctk_padding1) (void);
  void (*_ctk_padding2) (void);
  void (*_ctk_padding3) (void);
  void (*_ctk_padding4) (void);
  void (*_ctk_padding5) (void);
  void (*_ctk_padding6) (void);
};

typedef enum
{
  CTK_IMAGE_EMPTY,
  CTK_IMAGE_PIXBUF,
  CTK_IMAGE_STOCK,
  CTK_IMAGE_ICON_NAME,
  CTK_IMAGE_GICON,
  CTK_IMAGE_FILENAME
} CtkImageType;

GType          ctk_image_get_type (void) G_GNUC_CONST;

ClutterActor * ctk_image_new                    (guint size);

ClutterActor * ctk_image_new_from_pixbuf        (guint        size,
                                                 GdkPixbuf   *pixbuf);

ClutterActor * ctk_image_new_from_stock         (guint        size,
                                                 const gchar *stock_id);

ClutterActor * ctk_image_new_from_icon_name     (guint        size,
                                                 const gchar *icon_name);

ClutterActor * ctk_image_new_from_gicon         (guint        size,
                                                 GIcon       *icon);

ClutterActor * ctk_image_new_from_filename      (guint        size,
                                                 const gchar * filename);

CtkImageType   ctk_image_get_image_storage_type (CtkImage *image);

void           ctk_image_set_size               (CtkImage *image,
                                                 guint     size);

guint          ctk_image_get_size               (CtkImage *image);

void           ctk_image_set_from_pixbuf        (CtkImage  *image,
                                                 GdkPixbuf *pixbuf);

void           ctk_image_set_from_stock         (CtkImage    *image,
                                                 const gchar *stock_id);

void           ctk_image_set_from_icon_name     (CtkImage    *image,
                                                 const gchar *icon_name);

void           ctk_image_set_from_gicon         (CtkImage    *image,
                                                 GIcon       *icon);

void           ctk_image_set_from_filename      (CtkImage    *image,
                                                 const gchar *filename);

GdkPixbuf    * ctk_image_get_pixbuf             (CtkImage    *image);

const gchar  * ctk_image_get_stock              (CtkImage    *image);

const gchar  * ctk_image_get_icon_name          (CtkImage    *image);

GIcon        * ctk_image_get_gicon              (CtkImage    *image);

const gchar  * ctk_image_get_filename           (CtkImage    *image);


G_END_DECLS

#endif /* _CTK_IMAGE_H_ */

