from threading import Thread

import time

import gst
import gtk

class RepeatSound(Thread):
	def __init__(self, howmanytimes, button, volume, PlayerInstance, MainClass, sndfile):

		Thread.__init__(self)

		self.setDaemon(True)
		self.sndfile = sndfile
		self.button = button
		self.times = howmanytimes
		self.bus = PlayerInstance.get_bus()
		self.bus.add_signal_watch()
		self.bus.connect('message', self.BusMessage)
		self.time_format = gst.Format(gst.FORMAT_TIME)
		self.Repeated = 0	
		self.stop = False
		self.volume = volume / 100
		self.PlayerInstance = PlayerInstance
		self.PlayerInstance.set_property("volume", self.volume)
		self.stillrun = True
		self.MainClass = MainClass
		self.PlayerInstance.set_state(gst.STATE_PLAYING)
		self.PlayAgain = False
	def run(self):
		while self.stillrun or self.Repeated <= self.times or self.times == -1:
			time.sleep(0.01)
			if self.PlayAgain:
				if not self.Repeated < self.times - 1 and not self.times == -1: break
				self.PlayerInstance.set_property('uri', "file://" + self.sndfile)
				self.PlayerInstance.seek_simple(self.time_format, gst.SEEK_FLAG_FLUSH, 0)
				self.PlayerInstance.set_state(gst.STATE_PLAYING)
				if self.times > 0:
					self.Repeated += 1
				else:
					self.Repeated = -2
					self.PlayAgain = True
			self.PlayAgain = False



			if self.PlayerInstance.get_state()[1] == gst.STATE_NULL:
				break




		self.PlayerInstance.set_property("volume", 0)
		self.PlayerInstance.set_state(gst.STATE_NULL)
		self.Repeated = 0

		gtk.gdk.threads_enter()
		self.PlayerInstance.set_state(gst.STATE_NULL)
		gtk.gdk.threads_leave()
		self.stillrun = False


	def BusMessage(self, Bus, Message):
		if not self.MainClass.WhatPlaying == "R": return
		if self.PlayerInstance.get_state()[1] == gst.STATE_NULL: return
		if Message.type == gst.MESSAGE_EOS:

			if self.Repeated == self.times and not self.times < 0:
				gtk.gdk.threads_enter()
				self.MainClass.StopTheSound()
				gtk.gdk.threads_leave()
				self.stillrun = False
			self.PlayAgain = True



